/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.Collection;

final class CollectionTypeAdapterFactory$Adapter<E>
extends TypeAdapter<Collection<E>> {
    private final TypeAdapter<E> elementTypeAdapter;
    private final ObjectConstructor<? extends Collection<E>> constructor;

    public CollectionTypeAdapterFactory$Adapter(TypeAdapter<E> typeAdapter, ObjectConstructor<? extends Collection<E>> objectConstructor) {
        this.elementTypeAdapter = typeAdapter;
        this.constructor = objectConstructor;
    }

    @Override
    public Collection<E> read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Collection<E> collection = this.constructor.construct();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            E e = this.elementTypeAdapter.read(jsonReader);
            collection.add(e);
        }
        jsonReader.endArray();
        return collection;
    }

    @Override
    public void write(JsonWriter jsonWriter, Collection<E> collection) {
        if (collection == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        for (E e : collection) {
            this.elementTypeAdapter.write(jsonWriter, e);
        }
        jsonWriter.endArray();
    }
}

