/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.bind.EnumTypeAdapter$1;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    static final TypeAdapterFactory FACTORY = new EnumTypeAdapter$1();
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<String, T> stringToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();

    private EnumTypeAdapter(Class<T> clazz) {
        try {
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
            int n = 0;
            for (AccessibleObject accessibleObject : accessibleObjectArray) {
                if (!((Field)accessibleObject).isEnumConstant()) continue;
                accessibleObjectArray[n++] = accessibleObject;
            }
            accessibleObjectArray = Arrays.copyOf(accessibleObjectArray, n);
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            for (AccessibleObject accessibleObject : accessibleObjectArray) {
                Enum enum_ = (Enum)((Field)accessibleObject).get(null);
                String string = enum_.name();
                String string2 = enum_.toString();
                SerializedName serializedName = ((Field)accessibleObject).getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    string = serializedName.value();
                    for (String string3 : serializedName.alternate()) {
                        this.nameToConstant.put(string3, enum_);
                    }
                }
                this.nameToConstant.put(string, enum_);
                this.stringToConstant.put(string2, enum_);
                this.constantToName.put(enum_, string);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    @Override
    public T read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        Enum enum_ = (Enum)this.nameToConstant.get(string);
        return (T)(enum_ == null ? (Enum)this.stringToConstant.get(string) : enum_);
    }

    @Override
    public void write(JsonWriter jsonWriter, T t) {
        jsonWriter.value(t == null ? null : this.constantToName.get(t));
    }

    /* synthetic */ EnumTypeAdapter(Class clazz, EnumTypeAdapter$1 enumTypeAdapter$1) {
        this(clazz);
    }
}

