/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge;

import com.gravitlauncher.socketbridge.Constants;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class MessageHeader {
    public static final int BASE_HEADER_SIZE = 27;
    private final String name;
    private final boolean isResponse;
    private final long requestId;
    private final long contentLength;

    public MessageHeader(String string, boolean bl, long l, long l2) {
        this.name = string;
        this.isResponse = bl;
        this.requestId = l;
        this.contentLength = l2;
    }

    public byte[] serialize() {
        byte[] byArray = this.name.getBytes(StandardCharsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(27 + byArray.length);
        byteBuffer.putLong(Constants.MAGIC_NUMBER);
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.putLong(this.contentLength);
        byteBuffer.putLong(this.requestId);
        byteBuffer.put((byte)(this.isResponse ? 1 : 0));
        byteBuffer.put(byArray);
        return byteBuffer.array();
    }

    public static long calculateSize(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 27) {
            return 27 - byteBuffer.remaining();
        }
        long l = byteBuffer.getLong();
        if (l != Constants.MAGIC_NUMBER) {
            throw new RuntimeException("Invalid magic number");
        }
        short s = byteBuffer.getShort();
        long l2 = byteBuffer.getLong();
        long l3 = (long)(27 + s) + l2 - 8L - 2L - 8L;
        return l3 - (long)byteBuffer.remaining();
    }

    public static MessageHeader deserialize(ByteBuffer byteBuffer) {
        long l = byteBuffer.getLong();
        if (l != Constants.MAGIC_NUMBER) {
            throw new RuntimeException("Invalid magic number");
        }
        short s = byteBuffer.getShort();
        long l2 = byteBuffer.getLong();
        long l3 = byteBuffer.getLong();
        boolean bl = byteBuffer.get() != 0;
        byte[] byArray = new byte[s];
        byteBuffer.get(byArray);
        return new MessageHeader(new String(byArray, StandardCharsets.UTF_8), bl, l3, l2);
    }

    public String name() {
        return this.name;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public long requestId() {
        return this.requestId;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        MessageHeader messageHeader = (MessageHeader)object;
        return Objects.equals(this.name, messageHeader.name) && this.isResponse == messageHeader.isResponse && this.requestId == messageHeader.requestId && this.contentLength == messageHeader.contentLength;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isResponse, this.requestId, this.contentLength);
    }

    public String toString() {
        return "MessageHeader[name=" + this.name + ", isResponse=" + this.isResponse + ", requestId=" + this.requestId + ", contentLength=" + this.contentLength + ']';
    }
}

